/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.action;

import CH.ifa.draw.figures.LineConnection;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import DE.siemens.ad.kop.app.LogoDrawingViewKOP;
import DE.siemens.ad.kop.model.block.ContactBlock;
import DE.siemens.ad.logo.app.Editor;
import DE.siemens.ad.logo.app.action.ActionFactory;
import DE.siemens.ad.logo.app.action.LogoAction;
import DE.siemens.ad.logo.app.action.UndoableAction;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.InBlockConnectorEnumeration;
import DE.siemens.ad.logo.model.OutBlockConnector;
import DE.siemens.ad.pdraw.action.CutLineAction;
import DE.siemens.ad.pdraw.action.DeleteFigureAction;
import DE.siemens.ad.pdraw.action.InsertBlockAction;
import DE.siemens.ad.pdraw.action.InsertConnectionAction;
import DE.siemens.ad.pdraw.action.SequenceCompositeUndoableAction;
import DE.siemens.ad.pdraw.app.LogoComfort;
import DE.siemens.ad.pdraw.figures.BlockFigure;
import DE.siemens.ad.pdraw.figures.CutConnectFigure;
import DE.siemens.ad.pdraw.figures.FixedElbowConnection;
import DE.siemens.ad.pdraw.figures.constraints.ConnectionLineConstraint;
import DE.siemens.ad.pdraw.figures.constraints.InConnectorConstraint;
import DE.siemens.ad.pdraw.figures.constraints.OutConnectorConstraint;
import java.util.Iterator;
import java.util.Vector;

public class ReplaceBlocksAction
extends SequenceCompositeUndoableAction {
    private static final long serialVersionUID = 1175657602892576765L;
    private BlockFigure fOldFigure;
    private BlockFigure fNewFigure;

    public void setBlockFigures(BlockFigure oldFigure, BlockFigure newFigure) {
        this.fOldFigure = oldFigure;
        this.fNewFigure = newFigure;
    }

    protected void actionToStart(LogoAction action) {
        if (action instanceof CutLineAction) {
            this.getDrawingView().clearSelection();
            if (this.getDrawingView().selectionCount() == 0) {
                FixedElbowConnection f = ((CutLineAction)action).getOriginalConnection();
                this.getDrawingView().addToSelection(f);
            }
        }
    }

    public boolean doIt() {
        Vector actions = new Vector();
        actions.addAll(this.initAction(this.fOldFigure, this.fNewFigure));
        this.setChildActions(actions);
        if (super.doIt()) {
            ((LogoComfort)this.getOwner()).view().checkDamage();
            return true;
        }
        return false;
    }

    private Vector initAction(BlockFigure oldFigure, BlockFigure newFigure) {
        FixedElbowConnection connection;
        Iterator iter;
        int i;
        DrawingView view = ((LogoComfort)this.getOwner()).view();
        ActionFactory actionFactory = ((Editor)((Object)view.editor())).getActionManager().getActionFactory();
        InsertBlockAction insertAction = (InsertBlockAction)((InsertBlockAction)actionFactory.getAction("InsertBlockAction")).clone();
        insertAction.setBlockFigure(newFigure);
        Vector<UndoableAction> connectionActions = new Vector<UndoableAction>();
        int inconnCnt = oldFigure.getBlock().getInConnectorCount() > newFigure.getBlock().getInConnectorCount() ? newFigure.getBlock().getInConnectorCount() : oldFigure.getBlock().getInConnectorCount();
        for (i = 0; i < inconnCnt; ++i) {
            InBlockConnector OldIn = oldFigure.getBlock().getInConnector(i);
            if (OldIn.getLinkedConnectorsCount() <= 0 || OldIn.getSignalType() != newFigure.getBlock().getInConnector(i).getSignalType()) continue;
            iter = ((InConnectorConstraint)oldFigure.getInputIfcFigure(OldIn).getConstraint()).getConnectionLineConstraints().iterator();
            while (iter.hasNext()) {
                connection = new FixedElbowConnection();
                Figure f = ((LineConnection)((ConnectionLineConstraint)iter.next()).getFigure()).startFigure();
                boolean isSeperated = false;
                if (f instanceof CutConnectFigure) {
                    connection.connectStart(((CutConnectFigure)f).getPartner().getConnectionFigure().start());
                    isSeperated = true;
                } else {
                    connection.connectStart(f.connectorAt(0, 0));
                }
                connection.connectEnd(newFigure.getInputIfcFigure(newFigure.getBlock().getInConnector(i)).connectorAt(0, 0));
                InsertConnectionAction insertConnectionAction = (InsertConnectionAction)actionFactory.getAction("InsertConnectionAction");
                insertConnectionAction.setConnectionFigure(connection);
                connectionActions.add((InsertConnectionAction)insertConnectionAction.clone());
                if (!isSeperated) continue;
                CutLineAction cutLineAction = (CutLineAction)actionFactory.getAction("CutLineAction");
                cutLineAction.setOriginalConnection(connection);
                connectionActions.add((CutLineAction)cutLineAction.clone());
            }
        }
        for (i = 0; i < oldFigure.getBlock().getOutConnectorCount() && i + 1 <= newFigure.getBlock().getOutConnectorCount(); ++i) {
            OutBlockConnector oldOut = oldFigure.getBlock().getOutConnector(i);
            if (view instanceof LogoDrawingViewKOP && oldOut.getLinkedConnectorsCount() > 0) {
                InBlockConnectorEnumeration inConns = oldOut.getLinkedConnectors();
                while (inConns.hasMoreElements()) {
                    InBlockConnector inConn;
                    if (oldOut.getSignalType() != newFigure.getBlock().getOutConnector(i).getSignalType() || !((inConn = inConns.nextElement()).getOwner() instanceof ContactBlock)) continue;
                    ((ContactBlock)inConn.getOwner()).connectToValueSource(newFigure.getBlock().getOutConnector(i));
                }
            }
            if (oldOut.getLinkedConnectorsCount() <= 0 || oldOut.getSignalType() != newFigure.getBlock().getOutConnector(i).getSignalType()) continue;
            iter = ((OutConnectorConstraint)oldFigure.getOutputIfcFigure(oldOut).getConstraint()).getConnectionLineConstraints().iterator();
            while (iter.hasNext()) {
                connection = new FixedElbowConnection();
                ConnectionLineConstraint straint = (ConnectionLineConstraint)iter.next();
                Figure f = ((LineConnection)straint.getFigure()).endFigure();
                boolean isSeperated = false;
                if (f instanceof CutConnectFigure) {
                    connection.connectEnd(((CutConnectFigure)f).getPartner().getConnectionFigure().end());
                    isSeperated = true;
                } else {
                    connection.connectEnd(f.connectorAt(0, 0));
                }
                connection.connectStart(newFigure.getOutputIfcFigure(newFigure.getBlock().getOutConnector(i)).connectorAt(0, 0));
                InsertConnectionAction insertConnectionAction = (InsertConnectionAction)actionFactory.getAction("InsertConnectionAction");
                insertConnectionAction.setConnectionFigure(connection);
                connectionActions.add((InsertConnectionAction)insertConnectionAction.clone());
                if (!isSeperated) continue;
                CutLineAction cutLineAction = (CutLineAction)actionFactory.getAction("CutLineAction");
                cutLineAction.setOriginalConnection(connection);
                connectionActions.add((CutLineAction)cutLineAction.clone());
            }
        }
        DeleteFigureAction deleteFigureAction = (DeleteFigureAction)actionFactory.getAction("DeleteFigureAction");
        deleteFigureAction.setConstraint(oldFigure.getConstraint());
        Vector<Object> actions = new Vector<Object>();
        actions.add(deleteFigureAction.clone());
        actions.add(insertAction);
        actions.addAll(connectionActions);
        return actions;
    }

    public void undoIt() {
        super.undoIt();
        for (int i = 0; i < this.fNewFigure.getBlock().getOutConnectorCount() && i + 1 <= this.fOldFigure.getBlock().getOutConnectorCount(); ++i) {
            DrawingView view = ((LogoComfort)this.getOwner()).view();
            OutBlockConnector newOut = this.fNewFigure.getBlock().getOutConnector(i);
            if (!(view instanceof LogoDrawingViewKOP)) continue;
            while (newOut.getLinkedConnectorsCount() > 0) {
                InBlockConnectorEnumeration inConns = newOut.getLinkedConnectors();
                while (inConns.hasMoreElements()) {
                    InBlockConnector inConn;
                    if (newOut.getSignalType() != this.fOldFigure.getBlock().getOutConnector(i).getSignalType() || !((inConn = inConns.nextElement()).getOwner() instanceof ContactBlock)) continue;
                    ((ContactBlock)inConn.getOwner()).connectToValueSource(this.fOldFigure.getBlock().getOutConnector(i));
                }
            }
        }
    }
}

